#include "hx.h"
#include "hxd.h"
#include <string.h>
#include <time.h>
#include "xmalloc.h"

extern u_int8_t *path_to_hldir (const char *path, u_int16_t *hldirlen, int is_file);

extern char *hx_timeformat;
extern void mac_to_tm (struct tm *tm, u_int8_t *date);

static void
threadlist_print (struct htlc_conn *htlc, u_int8_t *tlbuf)
{
	struct hl_news_threadlist_hdr *lh;
	struct hl_news_thread_hdr *th;
	u_int32_t i, tc;
	u_int8_t *p, slen, plen, mlen, subject[256], poster[256], mimetype[256];
	u_int16_t datasize;
	char datestr[64];
	struct tm tm;

	lh = (struct hl_news_threadlist_hdr *)tlbuf;
	th = (struct hl_news_thread_hdr *)(tlbuf + SIZEOF_HL_NEWS_THREADLIST_HDR);
	tc = ntohl(lh->thread_count);
	hx_printf(htlc, 0, "NEWS: %08x  %08x  %04x\n", ntohl(lh->__x0), tc, ntohs(lh->__x1));
	for (i = 0; i < tc; i++) {
		p = ((u_int8_t *)th) + SIZEOF_HL_NEWS_THREAD_HDR;
		slen = *p;
		p++;
		memcpy(subject, p, slen);
		p += slen;
		subject[slen] = 0;
		plen = *p;
		p++;
		memcpy(poster, p, plen);
		p += plen;
		poster[plen] = 0;
		mlen = *p;
		p++;
		memcpy(mimetype, p, mlen);
		p += mlen;
		mimetype[mlen] = 0;
		L16NTOH(datasize, p);
		p += 2;
		mac_to_tm(&tm, th->date);
		strftime(datestr, sizeof(datestr)-1, hx_timeformat, &tm);
		hx_printf(htlc, 0, "id = %u parent = %u\n", ntohl(th->id), ntohl(th->parent_id));
		hx_printf(htlc, 0, "date: %s\n", datestr);
		hx_printf(htlc, 0, "subject: %s\n", subject);
		hx_printf(htlc, 0, "poster: %s\n", poster);
		hx_printf(htlc, 0, "mimetype: %s\n", mimetype);
		hx_printf(htlc, 0, "datasize = %u\n", datasize);
		th = (struct hl_news_thread_hdr *)p;
	}
}

static void
rcv_task_tnews_listcat (struct htlc_conn *htlc)
{
	dh_start(htlc)
		if (dh_type != HTLS_DATA_NEWS_CATLIST)
			continue;
		threadlist_print(htlc, dh_data-SIZEOF_HL_DATA_HDR);
	dh_end()
}

static void
rcv_task_tnews_list (struct htlc_conn *htlc)
{
	char *name;
	u_int16_t nlen;
	u_int8_t type;

	dh_start(htlc)
		if (dh_type != HTLS_DATA_NEWS_DIRLIST)
			continue;
		nlen = dh_len-1;
		type = *(dh_data);
		name = dh_data+1;
		hx_printf(htlc, 0, "%u  %.*s%s\n", type, nlen, name, type==1?"/":"");
	dh_end()
}

void
hx_tnews_list (struct htlc_conn *htlc, const char *path, int is_cat)
{
	u_int8_t *hldir;
	u_int16_t hldirlen;
	u_int32_t type;
	void (*tfn)();

	if (!htlc->fd)
		return;
	if (is_cat) {
		type = HTLC_HDR_NEWS_LISTCATEGORY;
		tfn = rcv_task_tnews_listcat;
	} else {
		type = HTLC_HDR_NEWS_LISTDIR;
		tfn = rcv_task_tnews_list;
	}
	task_new(htlc, tfn, 0, 0, "tnews_list");
	if (!strcmp(path, "/"))
		hlwrite(htlc, type, 0, 0);
	else {
		hldir = path_to_hldir(path, &hldirlen, 0);
		hlwrite(htlc, type, 0, 1,
			HTLC_DATA_NEWS_DIR, hldirlen, hldir);
		xfree(hldir);
	}
}

static void
rcv_task_tnews_get (struct htlc_conn *htlc)
{
	u_int32_t prevtid, nexttid, parenttid, nextsubtid;
	u_int8_t slen, plen, mlen, subject[256], poster[256], mimetype[256];
	char datestr[64];
	struct tm tm;

	dh_start(htlc)
		switch (dh_type) {
			case HTLS_DATA_NEWS_POST:
				CR2LF(dh_data, dh_len);
				hx_printf(htlc, 0, "NEWS: post data:\n%.*s\n", dh_len, dh_data);
				break;
			case HTLS_DATA_NEWS_PREVTHREADID:
				dh_getint(prevtid);
				break;
			case HTLS_DATA_NEWS_NEXTTHREADID:
				dh_getint(nexttid);
				break;
			case HTLS_DATA_NEWS_PARENTTHREADID:
				dh_getint(parenttid);
				break;
			case HTLS_DATA_NEWS_NEXTSUBTHREADID:
				dh_getint(nextsubtid);
				break;
			case HTLS_DATA_NEWS_SUBJECT:
				slen = dh_len > 255 ? 255 : dh_len;
				memcpy(subject, dh_data, slen);
				subject[slen] = 0;
				hx_printf(htlc, 0, "subject: %s\n", subject);
				break;
			case HTLS_DATA_NEWS_POSTER:
				plen = dh_len > 255 ? 255 : dh_len;
				memcpy(poster, dh_data, plen);
				poster[plen] = 0;
				hx_printf(htlc, 0, "poster: %s\n", poster);
				break;
			case HTLS_DATA_NEWS_MIMETYPE:
				mlen = dh_len > 255 ? 255 : dh_len;
				memcpy(mimetype, dh_data, mlen);
				mimetype[mlen] = 0;
				hx_printf(htlc, 0, "mimetype: %s\n", mimetype);
				break;
			case HTLS_DATA_NEWS_DATE:
				mac_to_tm(&tm, dh_data);
				strftime(datestr, sizeof(datestr)-1, hx_timeformat, &tm);
				hx_printf(htlc, 0, "date: %s\n", datestr);
				break;
			default:
				hx_printf(htlc, 0, "NEWS: %04x %04x\n", dh_type, dh_len);
				break;
		}
	dh_end()
}

void
hx_tnews_get (struct htlc_conn *htlc, const char *path, u_int16_t tid)
{
	char *mt;
	u_int16_t mtlen;
	u_int16_t ntid;
	u_int8_t *hldir;
	u_int16_t hldirlen;

	if (!htlc->fd)
		return;
	task_new(htlc, rcv_task_tnews_get, 0, 0, "tnews_get");
	hldir = path_to_hldir(path, &hldirlen, 0);
	mt = "text/plain";
	mtlen = strlen(mt);
	ntid = htons(tid);
	hlwrite(htlc, HTLC_HDR_NEWS_GETTHREAD, 0, 3,
		HTLC_DATA_NEWS_DIR, hldirlen, hldir,
		HTLC_DATA_NEWS_THREADID, 2, &ntid,
		HTLC_DATA_NEWS_MIMETYPE, mtlen, mt);
	xfree(hldir);
}

static void
rcv_task_news_file (struct htlc_conn *htlc)
{
	dh_start(htlc)
		if (dh_type != HTLS_DATA_NEWS)
			continue;
		htlc->news_len = dh_len;
		htlc->news_buf = xrealloc(htlc->news_buf, htlc->news_len + 1);
		memcpy(htlc->news_buf, dh_data, htlc->news_len);
		CR2LF(htlc->news_buf, htlc->news_len);
		strip_ansi(htlc->news_buf, htlc->news_len);
		htlc->news_buf[htlc->news_len] = 0;
	dh_end()
	hx_output.news_file(htlc, htlc->news_buf, htlc->news_len);
}

void
hx_get_news (struct htlc_conn *htlc)
{
	if (!htlc->fd)
		return;
	task_new(htlc, rcv_task_news_file, 0, 0, "news");
	hlwrite(htlc, HTLC_HDR_NEWSFILE_GET, 0, 0);
}

void
hx_post_news (struct htlc_conn *htlc, const char *news, u_int16_t len)
{
	task_new(htlc, 0, 0, 0, "post");
	hlwrite(htlc, HTLC_HDR_NEWSFILE_POST, 0, 1,
		HTLC_DATA_NEWSFILE_POST, len, news);
}
